varying vec2 f_texcoord;
uniform sampler2D texture[TEX_NUM];

varying float f_texfactor[TEX_NUM];

#define BLEND_RANGE 0.3

void main(void)
{
	vec4 colorResult = vec4(0.0);
	float sumFactors = 0.0;
	for(int i = 0; i < TEX_NUM; ++i)
	{
		float factor = f_texfactor[i];
		factor -= 0.5-BLEND_RANGE;
		factor /= 2.0*BLEND_RANGE;
		factor = clamp(factor, 0.0, 1.0);

		colorResult += factor * texture2D(texture[i], f_texcoord);
		sumFactors += factor;
	}
	colorResult /= sumFactors;
	colorResult.a = 1.0;

	gl_FragColor = colorResult;
}
